import { jest } from '@jest/globals';

const mockModule = await import('./database.js');

jest.unstable_mockModule('./database.js', () => ({
  ...mockModule,
  default: jest.fn(() => 1),
  fetchFromDatabase: jest.fn().mockResolvedValue({ id: 42, name: 'John Doe', email: 'john.doe@example.com' }),
}));

const { getUser, makeUser, getTotalUsers } = await import('./user.js');

test('getUser() returns correct name and email', async () => {
  const user = await getUser(1);
  expect(user.user).toBe('John Doe');
  expect(user.email).toBe('john.doe@example.com');
});

test('getTotalUsers() returns correct number', async () => {
  const numberOfUsers = getTotalUsers();
  expect(numberOfUsers).toBe(1);
});

test('makeUser() is callable', async() => {
  const newUser = await makeUser('Jane Doe', 'jane.doe@example.com');
  expect(newUser.user).toBe('Jane Doe');
  expect(newUser.email).toBe('jane.doe@example.com');
});
